<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["7rDMOe6Pyx8=","DncFySkOcPQ=","8EPzW7ojxE4=","lmbxxE5Rd50="]', true);
$__MASKS = json_decode('["MCETs0QUQE8=","\/5e2x919dFE=","+5l3IQxrgIU=","c6iyFUwTRi4="]', true);
$__ROT   = json_decode('[6,4,3,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('2mXfDfAvQOBPjMwFEGjviSuaTZg9ehbE');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2Jhc2UvdHJhaXRzL3NoYXJlZC13aWRnZXQtY29udHJvbHMtdHJhaXQucGhwIiwidHMiOjE3NTY2OTM3MTQsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('zA+H1h7IcmZ7o+QX2KcZVN4G5mrYat6/LVXOmC3l/Og=');
$__SIG = base64_decode('BZc8rGbu7FXUzfG/wh0MgUpPeyRIEJPEhfpgiiWbkARvwde8V8JIXLVjoJUzUlCeyhHTRs8pKtiKWBIhkRhQAg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
