<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["9VYgHAOX9hA=","YqP0nuwt6NY=","wXmHxvJNmzc=","pdncoMc\/7dI="]', true);
$__MASKS = json_decode('["iANLlahBpqM=","O0HlO17rims=","A6vbsP1mS68=","J+EyicQSNsA="]', true);
$__ROT   = json_decode('[5,7,4,5]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('j0oqg6Uti4MqUx3uuojd0mUMCylKh/g6');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2Jhc2UvcHJvdmlkZXJzL3NvY2lhbC1uZXR3b3JrLXByb3ZpZGVyLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('URVCj6qto77EYz64v236Jdf53twlUAM/optBvR6FP3c=');
$__SIG = base64_decode('BsoykTKlKvhGfK5/PaxaKld2W4rdkvSMw7B5r/1uDl5OwjFERj8fkBRWPw9yEVlSR11Z0x24WvM5cUmK4l0UBQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
