<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["bunoLgbdaek=","sLAx5IwySpI=","Zhlliz\/W9Og=","seVmpKSiru0="]', true);
$__MASKS = json_decode('["BNrDqTaJH0U=","NyxQUcF+LFk=","7+fXgFrOFaY=","HBLjR+K8y2Q="]', true);
$__ROT   = json_decode('[2,7,1,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('QmvY/r4WNS6Z4Bn5pxl2pEz2Sojh3QOM');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2Jhc2UvbW9kdWxlLnBocCIsInRzIjoxNzU2NjkzNzE0LCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('QHWQrffiOjmyZB5AkqJ8NAb/SKYBtDSuku+mEnajdVg=');
$__SIG = base64_decode('QKUkp4Fduhq4bAKxaw0YuG7iht8NYxo6RBS1fpa9XoWasNtF15pCnLd3XVStTKjeLZrzv1wB1IWHNf2zXE3hCQ==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
