<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["qQJkpnJNM30=","w4ZQarsJ4JE=","iiBlHIGNfjg=","E66dQ6iUT3k="]', true);
$__MASKS = json_decode('["DjudrL8nt74=","bwVAEJZuTow=","IJBPGdh8eJs=","+eYrtxXsa8s="]', true);
$__ROT   = json_decode('[5,3,3,2]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('Ts/ppJ42nytE63GTyFjeqwzOwD+NGIZX');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9jb3JlL2Jhc2UvYmFja2dyb3VuZC1wcm9jZXNzL3dwLWJhY2tncm91bmQtcHJvY2Vzcy5waHAiLCJ0cyI6MTc1NjY5MzcxMywiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('W0dUx0J+d6+ep/KXsDlWRJg6/A4jcCL4DNHu1kqWNNg=');
$__SIG = base64_decode('LYfQE70+fGC6Ihec+0sNLnBTkun/mUecnrHo8JYG/ZSGD1k1Df/we5NmGJ2jMHtHpQZ6kDpygI/iIduH5lrhDg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
