<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["uMx3E+RjEWg=","DFKz8f4mHUc=","uMoznt43VFs=","E49zL9oMBi4="]', true);
$__MASKS = json_decode('["m7f3J2wMZfY=","nBIl9r6Qb6w=","MIvfAzZdaLM=","qXYMIM+eLgg="]', true);
$__ROT   = json_decode('[2,5,4,3]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('e6Cvbh9gzehTTADvTajw6nPRCsSy8ugl');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9hcHAvbW9kdWxlcy9vbmJvYXJkaW5nL21vZHVsZS5waHAiLCJ0cyI6MTc1NjY5MzcxMywiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('ldbK7gjcapfg5s+6xtMd2R6cZHFuiDT31bW6o31Mpjs=');
$__SIG = base64_decode('rPzq1SRYBAXbGLF8wBwKs1/1KiR9WoR+MTrO2yODM9MrCStkagu5/oJxnuuePgQreTVkyFKr3mA1Ly+XCQEvAw==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
