<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["QwjQ597gl6A=","Ch\/KJOF+PIM=","NSV4mJerw9k=","lAcKKtFmvPQ="]', true);
$__MASKS = json_decode('["fK75U\/lcM\/Y=","H6voLp5PIp8=","AK+DTpHYM+A=","zgrlmmIHFvw="]', true);
$__ROT   = json_decode('[7,3,1,6]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('R7Z3SDXWG2z5XJELMnChHo4MQSa2w/6T');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9hcHAvbW9kdWxlcy9pbXBvcnQtZXhwb3J0L3dwLWNsaS5waHAiLCJ0cyI6MTc1NjY5MzcxMywiZXhwaXJlcyI6MCwiZG9tYWlucyI6WyJpdHNob21hci5pciJdLCJvbmxpbmUiOjAsIndwIjoxLCJhbGdvIjoieGNoYWNoYTIwcG9seTEzMDVfaWV0ZiJ9');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('NjpZ9TrWHGL7GSrFTFbLmNYDZKozxZi3JHhrU6lUmTE=');
$__SIG = base64_decode('iaouXbjxSiLLQQW6rVVAxV9ygRpv8KceDSPheyqRxoFrQHLNOAI8YF3kXQqmYy/x75k6D8FxnkRrrAMrJSQSDg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
