<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["sqNdApbd1cc=","B58f2rDxi34=","KBHvzTZ5XBs=","r5rJc9atGoU="]', true);
$__MASKS = json_decode('["GaaDQrpV5fA=","9gYzWg0sRuI=","7j7Op3EQlEQ=","TWb5niJmrQM="]', true);
$__ROT   = json_decode('[1,3,7,1]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('KMDvahalmpIU4OelN6+RvaJc4hRWcDrk');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9hcHAvbW9kdWxlcy9pbXBvcnQtZXhwb3J0L3Byb2Nlc3Nlcy9pbXBvcnQucGhwIiwidHMiOjE3NTY2OTM3MTMsImV4cGlyZXMiOjAsImRvbWFpbnMiOlsiaXRzaG9tYXIuaXIiXSwib25saW5lIjowLCJ3cCI6MSwiYWxnbyI6InhjaGFjaGEyMHBvbHkxMzA1X2lldGYifQ==');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('ARopBHytsZU7gB+ZLl4/AOtIjKB1rbHrYf+Z5v2bzkg=');
$__SIG = base64_decode('HgJhob7PuxGVp9FlQvxmdxMJtYwd6Hm3r0nzdT9nn/KBYt3QkXTJxFU276ziZh5XZoCp1ntkTsQg6Atk8PJBAg==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
