<?php
/**
 * Pro runtime stub.
 */

if (!extension_loaded('sodium')) { http_response_code(500); exit; }

// Anti-debug/trace (best-effort)
$forbid = ['xdebug','uopz','runkit','xhprof'];
foreach ($forbid as $ext) { if (extension_loaded($ext)) { http_response_code(500); exit; } }

$__ONLINE_ONLY = (int)('0');
if ($__ONLINE_ONLY) {
    if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') { exit; }
    $host = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    if ($host==='' || preg_match('/(^|\.)(localhost|127\.0\.0\.1|::1)$/i', $host)) { exit; }
}

// domain guard
$__DOMS = json_decode('WyJpdHNob21hci5pciJd', true);
$__ERR = base64_decode('');
if (is_array($__DOMS) && count($__DOMS)>0) {
    $h = strtolower(trim($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '')));
    $ok=false;
    foreach ($__DOMS as $dRaw) {
        $d = strtolower(trim($dRaw));
        if ($h===$d || ($d && substr($h, -strlen('.'.$d)) === '.'.$d)) { $ok=true; break; }
    }
    if (!$ok) { http_response_code(403); echo $__ERR; exit; }
}

// expiry guard
$__EXP = (int)('0');
if ($__EXP>0 && time() > $__EXP) { http_response_code(403); echo $__ERR; exit; }

// Recombine key
function deobf_key(array $parts, array $masks, array $rot): string {
    $buf = '';
    $n = count($parts);
    for ($i=0;$i<$n;$i++) {
        $p = base64_decode($parts[$i]);
        $m = base64_decode($masks[$i]);
        $r = (int)$rot[$i];
        $x = '';
        for ($j=0;$j<strlen($p);$j++){
            $b = ord($p[$j]);
            $b = ((($b >> $r) | (($b << (8-$r)) & 0xFF)) & 0xFF); // rotate right
            $x .= chr($b);
        }
        $buf .= ($x ^ $m);
    }
    return $buf;
}

$__PARTS = json_decode('["4GU+mW+n8rE=","L0if9gBrdcY=","M83DYBOfJUY=","LTSotasZHok="]', true);
$__MASKS = json_decode('["ddGln9vI9Fc=","4zswPn4ObE4=","xcmsOhrwSAg=","IZ+JRntGNyU="]', true);
$__ROT   = json_decode('[6,1,2,7]', true);
$__KEY   = deobf_key($__PARTS, $__MASKS, $__ROT);

$__NONCE = base64_decode('gCN5du948F54zAyDy3Iu1vGOC6lXjXby');
$__AAD   = base64_decode('eyJsaWNfbW9kZSI6ImxvY2FsIiwibGljX3VybCI6IiIsImxpY19hcHAiOiIiLCJsaWNfcHViIjoiIiwibGljX2NhY2hlIjozNjAwLCJidWlsZCI6IjA4N2Q2NDc4Y2RmNDAzNDAiLCJwYXRoIjoiL2hvbWUvaXRzaG9tYXIvaXRzaG9tYXIuaXIvc291cmNlL2VsZW1lbnRvci9hcHAvYXBwLnBocCIsInRzIjoxNzU2NjkzNzEzLCJleHBpcmVzIjowLCJkb21haW5zIjpbIml0c2hvbWFyLmlyIl0sIm9ubGluZSI6MCwid3AiOjEsImFsZ28iOiJ4Y2hhY2hhMjBwb2x5MTMwNV9pZXRmIn0=');
$__CT    = base64_decode('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');

// Signature verification
$__PK  = base64_decode('WKyMLg8lQZ3aMRmpBcxjkKbM9s7HXm407xYN/+ylnYw=');
$__SIG = base64_decode('y/hOwqL3fqMyVVXxUoLLMCwkcX2mmdjvkGnwLv4VmUha3KdoS+TiTIo4Y2WYZqiaksh1gl++2/N/OENVKXP5BA==');
if (!sodium_crypto_sign_verify_detached($__SIG, $__AAD.$__CT, $__PK)) { http_response_code(500); exit; }

$__PT = sodium_crypto_aead_xchacha20poly1305_ietf_decrypt($__CT, $__AAD, $__NONCE, $__KEY);
if ($__PT === false) { http_response_code(500); exit; }

$__IS_WP = (int)('1');
if ($__IS_WP) {
    if (!defined('ABSPATH') && !defined('WPINC')) { /* optional exit; */ }
}

// Execute using temp include
$__tmp = sys_get_temp_dir().'/._'.sha1('087d6478cdf40340'.__FILE__.mt_rand()).'.php';
file_put_contents($__tmp, $__PT); unset($__PT);
include $__tmp;
@unlink($__tmp);
